import CounterService from '../counter-service';
<#ibiztemplate>
TARGET=PSAPPCOUNTER
</#ibiztemplate>
/**
 * ${item.getName()}计数器服务对象基类
 *
 * @export
 * @class ${item.getCodeName()}CounterServiceBase
 */
export default class ${srfclassname('${item.getCodeName()}')}CounterServiceBase extends CounterService {

    /**
     * Creates an instance of  ${srfclassname('${item.getCodeName()}')}CounterServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}CounterServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.initCounterData();
        this.timer = setInterval(() => {
            this.fetchCounterData(this.context,this.viewparams);
        }, <#if item.getTimer()??>${item.getTimer()?c}<#else>6000</#if>);
    }

    /**
     * 初始化当前计数器数据对象
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}CounterServiceBase
     */
    public initCounterData(){
        this.fetchCounterData(this.context,this.viewparams);
    }

    /**
     * 查询数据
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}CounterServiceBase
     */
    public async fetchCounterData(context:any,data:any){
        <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()?? && item.getGetPSAppDEAction?? && item.getGetPSAppDEAction()??>
        let _appEntityService:any = await this.appEntityService.getService('${item.getPSAppDataEntity().getCodeName()?lower_case}');
        if (_appEntityService['${item.getGetPSAppDEAction().getCodeName()}'] && _appEntityService['${item.getGetPSAppDEAction().getCodeName()}'] instanceof Function) {
            let result = await _appEntityService['${item.getGetPSAppDEAction().getCodeName()}'](context,data, false);
            this.counterData = result.data;
        }
        </#if>
    }

    /**
     * 刷新数据
     *
     * @memberof ${srfclassname('${item.getCodeName()}')}CounterServiceBase
     */
    public async refreshData(){
        if (this['fetchCounterData'] && this['fetchCounterData'] instanceof Function) {
            await this.fetchCounterData(this.context,this.viewparams);
        }
    }

}